%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Function name: create_logfile
%
% Scope:    create/update "logfile" string vector
%
% Input:    logfile string vector pre-existing (cell),
%           argument (string) that identifies correction/function applied,
%           list of gas names (cell),
%           list of gas type "flags" (i.e., MPV positions) (double),
%           uncert (structure),
%           generic inputs (double) depending on correction/function applied (see code below)
%
% Output:   updated "logfile" string vector
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [logfile, uncert] = create_logfile(logfile,argument,gasnames,gastypeflag,uncert,input,input2,input3,input4,input5,input6,input7,input8)

    if strcmp(argument,'import')     
        logfile = string(append('---------- ', datestr(now),': Data imported'));
        logfile(height(logfile)+1,1) = string(append('PICARRO G5131-i data: ', string(input)));
        logfile(height(logfile)+1,1) = string(append('PICARRO G2401 data: ', string(input2)));
        logfile(height(logfile)+1,1) = string(append('MPV position data: ', string(input3)));
    end
 
%%
    if strcmp(argument,'print')      
        log_file = [input '_logfile.txt'];
        % Open the file for writing (creates it if it doesn't exist)
        fileID = fopen(log_file, 'w'); % 'a' mode appends to the file
        % Check if the file opened successfully
        if fileID == -1
            error('Cannot open log file: %s', logFileName);
        end
        logfile(height(logfile)+1,1) = string(append('---------- ', datestr(now),' Results written to file'));
        logfile(height(logfile)+1,1) = string(append(input,'_gastypes_mean.txt'));
        logfile(height(logfile)+1,1) = string(append(input,'_gastypes_stdev.txt'));
        logfile(height(logfile)+1,1) = string(append(input,'_gastypes_uncert.txt'));
        logfile(height(logfile)+1,1) = string(append(input,'_intervals_mean.txt'));
        logfile(height(logfile)+1,1) = string(append(input,'_intervals_stdev.txt'));
        logfile(height(logfile)+1,1) = string(append(input,'_intervals_uncert.txt'));
        logfile(height(logfile)+1,1) = string(append(input,'_logfile.txt'));
        %write to file
        for i = 1:height(logfile)
            fprintf(fileID, '%s\n', logfile(i,1));
        end
		fclose(fileID);
    end

%%

    if strcmp(argument,'binning')        
        logfile(height(logfile)+1,1) = string(append('---------- ', datestr(now),': Data binned'));
        logfile(height(logfile)+1,1) = "Gas types defined:";
        for i = 1:length(input2)
            logfile(height(logfile)+1,1) = string(append('Valve pos ',string(input2(i)),' = ',input3(i))); %d = %s\n', [gastypeflag(i) gasnames{i}]));
        end
        if input(1,8) == 0
            logfile(height(logfile)+1,1) = "Plateau type: Fixed duration"; 
            logfile(height(logfile)+1,1) = string(append('Plateau duration = ', string(input(1,6)),' min'));
        end
        if input(1,8) == 1
            logfile(height(logfile)+1,1) = "Plateau type: Cutoff parameters"; 
            logfile(height(logfile)+1,1) = string(append('Cutoff N2O st-dev = ', string(input(1,2)),' ppb'));
            logfile(height(logfile)+1,1) = string(append('Cutoff N2O min-max = ', string(input(1,3)),' ppb'));
            logfile(height(logfile)+1,1) = string(append('Cutoff press st-dev = ', string(input(1,4)),' mTorr'));
            logfile(height(logfile)+1,1) = string(append('Cutoff press min-max = ', string(input(1,5)),' mTorr'));
            logfile(height(logfile)+1,1) = string(append('Cutoff min duration = ', string(input(1,1)),' min'));
        end
        logfile(height(logfile)+1,1) = string(append('Integration time = ', string(input(1,7)),' s'));    
        
        %initialize uncert structure
        uncert.log=zeros(3,4);      %3=isotopologues,4=corrections(n2o,ch4,co2,cal)
        uncert.log_conc=zeros(4,1); %4=species(n2o,ch4,co,co2),1=corrections(cal)
        uncert.check=0;             %flag for output file generation
        
    end
    
%%
    
    if strcmp(argument,'par_corr_conc')
        logfile(height(logfile)+1,1) = string(append('---------- ', datestr(now),': Applied parameter correction to N2O concentration'));
        logfile(height(logfile)+1,1) = string(append('Anchor dataset = ', string(input2)));
        if input == 1
            logfile(height(logfile)+1,1) = "Parameter = p_Cell"; end
        if input == 2
            logfile(height(logfile)+1,1) = "Parameter =  T_Cell"; end
        if input == 3
            logfile(height(logfile)+1,1) = "Parameter = T_Chiller"; end
        if input == 4
            logfile(height(logfile)+1,1) = "Parameter = T_P9"; end
    end
    
%%
    
    if strcmp(argument,'drift_corr_conc')
        logfile(height(logfile)+1,1) = string(append('---------- ', datestr(now),': Applied drift correction to concentrations'));
        logfile(height(logfile)+1,1) = string(append('Anchor dataset = ', string(input2)));
        logfile(height(logfile)+1,1) = string(append('Corrected concentrations = '));
        if input(1,1) == 1
            logfile(height(logfile)+1,1) = "N2O"; end
        if input(1,2) == 1 && input3.data_ch4_idx==1
            logfile(height(logfile)+1,1) = "CH4"; end
        if input(1,3) == 1 && input3.data_ch4_idx==1
            logfile(height(logfile)+1,1) = "CO"; end
        if input(1,4) == 1 && input3.data_ch4_idx==1
            logfile(height(logfile)+1,1) = "CO2"; end
    end

%%    
    
    if strcmp(argument,'cal_corr_conc') 
        logfile(height(logfile)+1,1) = string(append('---------- ', datestr(now),': Applied calibration correction to concentrations'));
        logfile(height(logfile)+1,1) = string(append('Type of correction = '));
        if input6(1,1) == 1
            logfile(height(logfile)+1,1) = "1-point calibration"; end
        if input6(1,1) == 2
            logfile(height(logfile)+1,1) = "2-point calibration"; end
        logfile(height(logfile)+1,1) = string(append('Corrected parameters = '));
        if input5(1,1) == 1
            logfile(height(logfile)+1,1) = "N2O"; end
        if input5(1,2) == 1 && input7.data_ch4_idx==1
            logfile(height(logfile)+1,1) = "CH4"; end
        if input5(1,3) == 1 && input7.data_ch4_idx==1
            logfile(height(logfile)+1,1) = "CO"; end
        if input5(1,4) == 1 && input7.data_ch4_idx==1
            logfile(height(logfile)+1,1) = "CO2"; end
        
        logfile(height(logfile)+1,1) = string(append('Calibration gas 1 = ', input)); 
        if input5(1,1) == 1
            logfile(height(logfile)+1,1) = string(append('True value N2O ', input,' = ',string(input3(1,1)),' ppb')); end
         if input5(1,2) == 1 && input7.data_ch4_idx==1
            logfile(height(logfile)+1,1) = string(append('True value CH4 ', input,' = ',string(input3(1,2)),' ppm')); end
         if input5(1,3) == 1 && input7.data_ch4_idx==1
            logfile(height(logfile)+1,1) = string(append('True value CO ', input,' = ',string(input3(1,3)),' ppm')); end
         if input5(1,4) == 1 && input7.data_ch4_idx==1
            logfile(height(logfile)+1,1) = string(append('True value CO2 ', input,' = ',string(input3(1,4)),' ppm')); end
        
        if input6(1,1) == 2
             logfile(height(logfile)+1,1) = string(append('Calibration gas 2 = ', input2)); 
             if input5(1,1) == 1 
                logfile(height(logfile)+1,1) = string(append('True value N2O ', input2,' = ',string(input4(1,1)),' ppb')); end
             if input5(1,2) == 1 && input7.data_ch4_idx==1
                logfile(height(logfile)+1,1) = string(append('True value CH4 ', input2,' = ',string(input4(1,2)),' ppm')); end
             if input5(1,3) == 1 && input7.data_ch4_idx==1
                logfile(height(logfile)+1,1) = string(append('True value CO ', input2,' = ',string(input4(1,3)),' ppm')); end
             if input5(1,4) == 1 && input7.data_ch4_idx==1
                logfile(height(logfile)+1,1) = string(append('True value CO2 ', input2,' = ',string(input4(1,4)),' ppm')); end
        end
        
        if input6(1,1) == 1 && input5(1,1) == 1
           uncert.log_conc(1,1)=1; end
        if input6(1,1) == 1 && input5(1,2) == 1  && input7.data_ch4_idx==1
           uncert.log_conc(2,1)=1; end
        if input6(1,1) == 1 && input5(1,3) == 1  && input7.data_ch4_idx==1
           uncert.log_conc(3,1)=1; end
        if input6(1,1) == 1 && input5(1,4) == 1  && input7.data_ch4_idx==1
           uncert.log_conc(4,1)=1; end
        if input6(1,1) == 2 && input5(1,1) == 1
           uncert.log_conc(1,1)=2; end
        if input6(1,1) == 2 && input5(1,2) == 1  && input7.data_ch4_idx==1
           uncert.log_conc(2,1)=2; end
        if input6(1,1) == 2 && input5(1,3) == 1  && input7.data_ch4_idx==1
           uncert.log_conc(3,1)=2; end
       if input6(1,1) == 2 && input5(1,4) == 1  && input7.data_ch4_idx==1
           uncert.log_conc(4,1)=2; end
       
    end

%%
    
    if strcmp(argument,'par_corr')
        logfile(height(logfile)+1,1) = string(append('---------- ', datestr(now),': Applied parameter correction to Delta-values'));
        logfile(height(logfile)+1,1) = string(append('Anchor dataset = ', string(input2)));
        if input == 1
            logfile(height(logfile)+1,1) = "Parameter = p_Cell"; end
        if input == 2
            logfile(height(logfile)+1,1) = "Parameter =  T_Cell"; end
        if input == 3
            logfile(height(logfile)+1,1) = "Parameter = T_Chiller"; end
        if input == 4
            logfile(height(logfile)+1,1) = "Parameter = T_P9"; end
    end

%%    
    
    if strcmp(argument,'n2o_conc_corr')
        logfile(height(logfile)+1,1) = string(append('---------- ', datestr(now),': Applied N2O concentration correction to Delta-values'));
        logfile(height(logfile)+1,1) = string(append('Anchor dataset = ', string(input2)));
        logfile(height(logfile)+1,1) = string(append('Slope d15Na = ', string(input(1,1)),' permil*ppb N2O'));
        logfile(height(logfile)+1,1) = string(append('Slope d15Nb = ', string(input(1,2)),' permil*ppb N2O'));
        logfile(height(logfile)+1,1) = string(append('Slope d18O = ', string(input(1,3)),' permil*ppb N2O'));    
        uncert.log(1:3,1)=1;
    end

%%    
    
    if strcmp(argument,'ch4_spec_inter_corr')
        logfile(height(logfile)+1,1) = string(append('---------- ', datestr(now),': Applied CH4 spectral interference correction to Delta-values'));
        logfile(height(logfile)+1,1) = string(append('Anchor dataset = ', string(input2)));
        logfile(height(logfile)+1,1) = string(append('Slope d15Na = ', string(input(1,1)),' permil*ppb N2O/ppm CH4'));
        logfile(height(logfile)+1,1) = string(append('Slope d15Nb = ', string(input(1,2)),' permil*ppb N2O/ppm CH4'));
        logfile(height(logfile)+1,1) = string(append('Slope d18O = ', string(input(1,3)),' permil*ppb N2O/ppm CH4'));    
        uncert.log(1:3,2)=1;
    end

%%    
    
    if strcmp(argument,'co2_spec_inter_corr')
        logfile(height(logfile)+1,1) = string(append('---------- ', datestr(now),': Applied CO2 spectral interference correction to Delta-values'));
        logfile(height(logfile)+1,1) = string(append('Anchor dataset = ', string(input2)));
        logfile(height(logfile)+1,1) = string(append('Slope d15Na = ', string(input(1,1)),' permil*ppb N2O/ppm CO2'));
        logfile(height(logfile)+1,1) = string(append('Slope d15Nb = ', string(input(1,2)),' permil*ppb N2O/ppm CO2'));
        logfile(height(logfile)+1,1) = string(append('Slope d18O = ', string(input(1,3)),' permil*ppb N2O/ppm CO2'));    
        uncert.log(1:3,3)=1;
    end

%%    
    
    if strcmp(argument,'drift_corr')
        logfile(height(logfile)+1,1) = string(append('---------- ', datestr(now),': Applied drift correction to Delta-values'));
        logfile(height(logfile)+1,1) = string(append('Anchor dataset = ', string(input2)));
        logfile(height(logfile)+1,1) = string(append('Corrected parameters = '));
        if input(1,1) == 1
            logfile(height(logfile)+1,1) = "d15Na"; end
        if input(1,2) == 1
            logfile(height(logfile)+1,1) = "d15Nb"; end
        if input(1,3) == 1
            logfile(height(logfile)+1,1) = "d18O"; end
    end

%%    
    
    if strcmp(argument,'cal_corr')
        logfile(height(logfile)+1,1) = string(append('---------- ', datestr(now),': Applied calibration correction to Delta-values'));
        logfile(height(logfile)+1,1) = string(append('Type of correction = '));
        if input6(1,1) == 1
            logfile(height(logfile)+1,1) = "1-point calibration"; end
        if input6(1,1) == 2
            logfile(height(logfile)+1,1) = "2-point calibration"; end
        logfile(height(logfile)+1,1) = string(append('Corrected parameters = '));
        if input5(1,1) == 1
            logfile(height(logfile)+1,1) = "d15Na"; end
        if input5(1,2) == 1
            logfile(height(logfile)+1,1) = "d15Nb"; end
        if input5(1,3) == 1
            logfile(height(logfile)+1,1) = "d18O"; end
        
        logfile(height(logfile)+1,1) = string(append('Calibration gas 1 = ', input)); 
         if input5(1,1) == 1
            logfile(height(logfile)+1,1) = string(append('True value d15Na ', input,' = ',string(input3(1,1)),' permil')); end
         if input5(1,2) == 1
            logfile(height(logfile)+1,1) = string(append('True value d15Nb ', input,' = ',string(input3(1,2)),' permil')); end
         if input5(1,3) == 1
            logfile(height(logfile)+1,1) = string(append('True value d18O ', input,' = ',string(input3(1,3)),' permil')); end     
        
        if input6(1,1) == 2
             logfile(height(logfile)+1,1) = string(append('Calibration gas 2 = ', input2)); 
             if input5(1,1) == 1
                logfile(height(logfile)+1,1) = string(append('True value d15Na ', input2,' = ',string(input4(1,1)),' permil')); end
             if input5(1,2) == 1
                logfile(height(logfile)+1,1) = string(append('True value d15Nb ', input2,' = ',string(input4(1,2)),' permil')); end
             if input5(1,3) == 1
                logfile(height(logfile)+1,1) = string(append('True value d18O ', input2,' = ',string(input4(1,3)),' permil')); end
        end   
        
        if input6(1,1) == 1 && input5(1,1) == 1
           uncert.log(1,4)=1; end
        if input6(1,1) == 1 && input5(1,2) == 1
           uncert.log(2,4)=1; end
        if input6(1,1) == 1 && input5(1,3) == 1
           uncert.log(3,4)=1; end
        if input6(1,1) == 2 && input5(1,1) == 1
           uncert.log(1,4)=2; end
        if input6(1,1) == 2 && input5(1,2) == 1
           uncert.log(2,4)=2; end
        if input6(1,1) == 2 && input5(1,3) == 1
           uncert.log(3,4)=2; end
        
    end
    
    %%
    
    if strcmp(argument,'uncert')
        logfile(height(logfile)+1,1) = string(append('---------- ', datestr(now),': Calculated uncertainties'));
        if uncert.log(1,1) == 1 
            logfile(height(logfile)+1,1) = string(append('Uncertainty on N2O concentration correction slope (alpha, beta, 18O): '));
            logfile(height(logfile)+1,1) = string(append(string(input(1,1)),', ',string(input(1,2)),', ',string(input(1,3)),' permil*ppb N2O')); 
        end
        if uncert.log(1,2) == 1 
            logfile(height(logfile)+1,1) = string(append('Uncertainty on CH4 spectral interference correction slope (alpha, beta, 18O): '));
            logfile(height(logfile)+1,1) = string(append(string(input2(1,1)),', ',string(input2(1,2)),', ',string(input2(1,3)),' permil*ppb N2O/ppm CH4')); 
        end
        if uncert.log(1,3) == 1 
            logfile(height(logfile)+1,1) = string(append('Uncertainty on CO2 spectral interference correction slope (alpha, beta, 18O): '));
            logfile(height(logfile)+1,1) = string(append(string(input3(1,1)),', ',string(input3(1,2)),', ',string(input3(1,3)),' permil*ppb N2O/ppm CO2')); 
        end
        
        label={'Uncertainty due to calibration correction (alpha)','Uncertainty due to calibration correction (beta)','Uncertainty due to calibration correction (18O)'};
        for z=1:3        
           logfile(height(logfile)+1,1) = string(append(label{1,z}));
           if uncert.log(z,4)==2 
              logfile(height(logfile)+1,1) = string(append('Type: 2-point calibration'));
              logfile(height(logfile)+1,1) = string(append('Calibration gas 1 = ', input5)); 
              logfile(height(logfile)+1,1) = string(append('Uncertainty = ',string(input6(1,z)),' permil'));
              logfile(height(logfile)+1,1) = string(append('Calibration gas 1 = ', input7));               
              logfile(height(logfile)+1,1) = string(append('Uncertainty = ',string(input8(1,z)),' permil'));
           end           
           if uncert.log(z,4)==1 
              logfile(height(logfile)+1,1) = string(append('Type: 1-point calibration'));
              logfile(height(logfile)+1,1) = string(append('Calibration gas 1 = ', input5)); 
              logfile(height(logfile)+1,1) = string(append('Uncertainty = ',string(input6(1,z)),' permil'));
           end          
           if uncert.log(z,4)==0 
              logfile(height(logfile)+1,1) = string(append('Type: No calibration'));
           end        
        end
        
        logfile(height(logfile)+1,1) = string(append('Uncertainty due to poorly understood effects (alpha, beta, 18O): '));
        logfile(height(logfile)+1,1) = string(append(string(input4(1,1)),', ',string(input4(1,2)),', ',string(input4(1,3)),' permil')); 
        
        
        %uncert.check=1;

        
    end
    
    
end